// Helper function to get the appropriate dashboard route based on user role
export const getDashboardRoute = (userRole?: string | { name: string }) => {
  if (!userRole) return '/';
  
  // Handle both string role and role object with name property
  const roleName = typeof userRole === 'object' && userRole !== null 
    ? userRole.name 
    : userRole;
  
  switch (roleName) {
    case 'admin':
    case 'superadmin':
      return '/admin/dashboard';
    case 'store_manager':
      return '/store/dashboard';
    case 'customer':
      return '/home';
    case 'delivery_boy':
    case 'delivery': // For backward compatibility
      return '/delivery/dashboard';
    case 'pharmacist':
      return '/pharmacist/dashboard';
    case 'picker_packer':
      return '/pickerpacker/dashboard';
    default:
      return '/';
  }
};
