import React from 'react';
import Layout from '@/components/shared/Layout';
import Sidebar from '@/components/shared/Sidebar';
import { adminSidebarItems } from '../AdminLayout';

const SocialSettings: React.FC = () => {
  return (
    <Layout title="Social Media Settings" sidebar={<Sidebar items={adminSidebarItems} />}>
      <div className="space-y-6 max-w-4xl mx-auto pb-12">
        <div className="bg-white p-8 rounded-lg shadow">
          <h1 className="text-xl font-semibold mb-4">Social Media Links</h1>
          <p>Add or update your social media accounts for display on your site.</p>
          {/* Social media link forms will go here */}
          <div className="mt-6 text-gray-500">Enhance your site with social connectivity soon.</div>
        </div>
      </div>
    </Layout>
  );
};

export default SocialSettings;
