import React from 'react';
import Layout from '@/components/shared/Layout';
import Sidebar from '@/components/shared/Sidebar';
import { adminSidebarItems } from '../AdminLayout';

const AppearanceSettings: React.FC = () => {
  return (
    <Layout title="Appearance Settings" sidebar={<Sidebar items={adminSidebarItems} />}>
      <div className="space-y-6 max-w-4xl mx-auto pb-12">
        <div className="bg-white p-8 rounded-lg shadow">
          <h1 className="text-xl font-semibold mb-4">Appearance Settings</h1>
          <p>This section will allow you to customize the look and feel of your site (theme colors, logo, favicon, fonts, etc.).</p>
          {/* Appearance setting forms and uploaders will go here */}
          <div className="mt-6 text-gray-500">More appearance options coming soon.</div>
        </div>
      </div>
    </Layout>
  );
};

export default AppearanceSettings;
