import React from 'react';
import { useWebSettings } from '../context/WebSettingsContext';
import Maintenance from '../pages/admin/web-settings/Maintenance';

interface MaintenanceWrapperProps {
  children: React.ReactNode;
}

const MaintenanceWrapper: React.FC<MaintenanceWrapperProps> = ({ children }) => {
  const { isMaintenanceMode, loading } = useWebSettings();

  // Don't render anything while loading to avoid flash of content
  if (loading) {
    return null;
  }

  // If in maintenance mode, show the maintenance page
  if (isMaintenanceMode) {
    return <Maintenance />;
  }

  // Otherwise, render the children
  return <>{children}</>;
};

export default MaintenanceWrapper;
