/**
 * Picks specific properties from an object
 * @param {Object} object - The source object
 * @param {string[]} keys - Array of keys to pick from the object
 * @returns {Object} A new object with only the picked properties
 */
const pick = (object, keys) => {
  return keys.reduce((obj, key) => {
    if (object && Object.prototype.hasOwnProperty.call(object, key)) {
      // If the key exists in the object, add it to the result
      obj[key] = object[key];
    }
    return obj;
  }, {});
};

module.exports = pick;
