const express = require('express');
const router = express.Router();
const wishlistsController = require('../controllers/wishlistsController');

// Get all wishlists
router.get('/', wishlistsController.getAllWishlists);

// Get wishlist by ID
router.get('/:id', wishlistsController.getWishlistById);

// Get users who wishlisted a specific product
router.get('/product/:item_id/users', wishlistsController.getProductWishlistUsers);

// Create new wishlist
router.post('/', wishlistsController.createWishlist);

// Update wishlist
router.put('/:id', wishlistsController.updateWishlist);

// Delete wishlist
router.delete('/:id', wishlistsController.deleteWishlist);

module.exports = router;
