const express = require('express');
const router = express.Router();
const { auth: protect, authorize } = require('../middleware/auth');
const asyncHandler = require('../middleware/async');
const {
  getSettings,
  updateSettings,
  getSettingsMiddleware
} = require('../controllers/webSettingsController');

// Apply settings middleware to all routes
router.use(getSettingsMiddleware);

// Public routes (no auth required)
router.get('/', asyncHandler(getSettings));
router.get('/public', asyncHandler(getSettings));

// Protected routes (admin only)
router.use(protect);
router.use(authorize('admin'));

router
  .route('/')
  .put(asyncHandler(updateSettings));

module.exports = router;
