const express = require('express');
const router = express.Router();
const transactionsController = require('../controllers/transactionsController');

// Get all transactions
router.get('/', transactionsController.getAllTransactions);

// Get transaction statistics
router.get('/stats', transactionsController.getTransactionStats);

// Get transaction by ID
router.get('/:id', transactionsController.getTransactionById);

// Get transactions by user ID
router.get('/user/:user_id', transactionsController.getTransactionsByUser);

// Create new transaction
router.post('/', transactionsController.createTransaction);

// Update transaction status
router.patch('/:id/status', transactionsController.updateTransactionStatus);

// Delete transaction
router.delete('/:id', transactionsController.deleteTransaction);

module.exports = router;
