const express = require('express');
const router = express.Router();
const {
  getAllTaxes,
  getTaxById,
  createTax,
  updateTax,
  toggleTaxStatus,
  deleteTax,
  getActiveTaxes,
  getTaxStatistics,
  searchTaxes
} = require('../controllers/taxesController');

// Search taxes (must be before /:id routes)
router.get('/search', searchTaxes);

// Get tax statistics
router.get('/analytics/statistics', getTaxStatistics);

// Get active taxes for dropdown
router.get('/active', getActiveTaxes);

// Get all taxes with pagination
router.get('/', getAllTaxes);

// Get tax by ID
router.get('/:id', getTaxById);

// Create new tax
router.post('/', createTax);

// Update tax
router.put('/:id', updateTax);

// Toggle tax status
router.patch('/:id/toggle-status', toggleTaxStatus);

// Delete tax (hard delete)
router.delete('/:id', deleteTax);

module.exports = router; 