const express = require('express');
const router = express.Router();
const uploadFiles = require('../middleware/multer');
const {
  getAllStores,
  getStoreById,
  createStore,
  updateStore,
  toggleStoreStatus,
  deleteStore,
  searchStores,
  getStoreStatistics,
  getStoresByCity,
  getActiveStores,
  updateStockAlertSettings,
  getStockAlertSettings,
  getNearbyStores
} = require('../controllers/storesController');

// Get all stores
router.get('/', getAllStores);

// Get active stores for dropdown
router.get('/active', getActiveStores);

// Search stores
router.get('/search', searchStores);

// Get store statistics
router.get('/analytics/statistics', getStoreStatistics);

// Get stores by city
router.get('/city/:city', getStoresByCity);

// Get nearby stores - supports both /find and /nearby for backward compatibility
router.get(['/find', '/nearby'], getNearbyStores);

// Get store by ID
router.get('/:id', getStoreById);

// Create new store with file uploads
router.post('/', uploadFiles, createStore);

// Update store
router.put('/:id', updateStore);

// Toggle store status
router.patch('/:id/toggle-status', toggleStoreStatus);

// Delete store
router.delete('/:id', deleteStore);

// Update store - keep this for general store updates
router.put('/:id', updateStore);

module.exports = router; 