const express = require('express');
const {
  getAllReturns,
  getReturnById,
  createReturn,
  updateReturn,
  deleteReturn,
} = require('../controllers/returnsController');

const Return = require('../models/Return');
const advancedResults = require('../middleware/advancedResults');
const { auth, authorize } = require('../middleware/auth');

const router = express.Router();

router.use(auth);
router.use(authorize('admin', 'superadmin'));

router
  .route('/')
  .get(advancedResults(Return, [{ path: 'order', select: 'orderNumber' }, { path: 'customer', select: 'name' }]), getAllReturns)
  .post(createReturn);

router
  .route('/:id')
  .get(getReturnById)
  .put(updateReturn)
  .delete(deleteReturn);

module.exports = router;
