const express = require('express');
const router = express.Router();
const { auth, authorize } = require('../middleware/auth');
const reportController = require('../controllers/reportController');

// Protect all routes with authentication
router.use(auth);

// Authorize routes based on user role
router.get('/sales', authorize('admin', 'customer'), reportController.getSalesReport);
router.get('/sales/export', authorize('admin'), reportController.exportSalesReport);
router.get('/periods', authorize('admin', 'customer'), reportController.getReportPeriods);

module.exports = router;
