const express = require('express');
const router = express.Router();
const pickerPackerController = require('../controllers/pickerPackerController');
const { auth: protect } = require('../middleware/auth');
const { uploadBrandImage } = require('../middleware/upload');

// Using uploadBrandImage middleware for picker packer image uploads

// Get all picker packers with pagination and search
router.get('/', protect, pickerPackerController.getPickerPackers);

// Get picker packer by user ID
router.get('/user/:userId', protect, pickerPackerController.getPickerPackerByUserId);

// Get picker packer by ID
router.get('/:id', protect, pickerPackerController.getPickerPackerById);

// Create a new picker packer
router.post('/', protect, uploadBrandImage, pickerPackerController.createPickerPacker);

// Update a picker packer
router.put('/:id', protect, uploadBrandImage, pickerPackerController.updatePickerPacker);

// Delete a picker packer
router.delete('/:id', protect, pickerPackerController.deletePickerPacker);

// Get picker packer statistics
router.get('/stats/overview', protect, pickerPackerController.getPickerPackerStats);

module.exports = router;