const express = require('express');
const router = express.Router();
const { auth } = require('../middleware/auth');
const notificationController = require('../controllers/notificationController');

// Apply auth middleware to all routes
router.use(auth);

// @route   GET /api/notifications
// @desc    Get all notifications for current user
// @access  Private
router.get('/', notificationController.getUserNotifications);

// @route   PUT /api/notifications/read-all
// @desc    Mark all notifications as read
// @access  Private
router.put('/read-all', notificationController.markAllAsRead);

// @route   PUT /api/notifications/:id/read
// @desc    Mark a notification as read
// @access  Private
router.put('/:id/read', notificationController.markAsRead);

// @route   DELETE /api/notifications/:id
// @desc    Delete a notification
// @access  Private
router.delete('/:id', notificationController.deleteNotification);

// @route   DELETE /api/notifications
// @desc    Delete all notifications for current user
// @access  Private
router.delete('/', notificationController.deleteAllNotifications);

module.exports = router;
