const express = require('express');
const router = express.Router();
const {
  getAllDeliveryBoyFunds,
  getDeliveryBoyFundsById,
  createDeliveryBoyFunds,
  updateDeliveryBoyFunds,
  deleteDeliveryBoyFunds
} = require('../controllers/deliveryBoyFundsController');

// Get all delivery boy funds
router.get('/', getAllDeliveryBoyFunds);

// Get delivery boy funds by ID
router.get('/:id', getDeliveryBoyFundsById);

// Create new delivery boy funds record
router.post('/', createDeliveryBoyFunds);

// Update delivery boy funds record
router.put('/:id', updateDeliveryBoyFunds);

// Delete delivery boy funds record
router.delete('/:id', deleteDeliveryBoyFunds);

module.exports = router;
