const express = require('express');
const router = express.Router();
const {
  getAllDeliveryBoyCash,
  getDeliveryBoyCashById,
  createDeliveryBoyCash,
  updateDeliveryBoyCash,
  deleteDeliveryBoyCash
} = require('../controllers/deliveryBoyCashController');

// Get all delivery boy cash collections
router.get('/', getAllDeliveryBoyCash);

// Get delivery boy cash collection by ID
router.get('/:id', getDeliveryBoyCashById);

// Create new delivery boy cash collection
router.post('/', createDeliveryBoyCash);

// Update delivery boy cash collection
router.put('/:id', updateDeliveryBoyCash);

// Delete delivery boy cash collection
router.delete('/:id', deleteDeliveryBoyCash);

module.exports = router;
