const express = require('express');
const router = express.Router();
const customersController = require('../controllers/customersController');
const { catchAsync } = require('../middleware/errorHandler');
const { auth, authorize } = require('../middleware/auth');

// Get all customers (admin only)
router.get('/', auth, authorize('admin'), catchAsync(customersController.getAllCustomers));

// Get customer by ID (admin only)
router.get('/:id', auth, authorize('admin'), catchAsync(customersController.getCustomerById));

// Update customer profile (admin or self)
router.put('/:id', auth, authorize('admin', 'customer'), catchAsync(customersController.updateCustomerProfile));

// Delete a customer (admin only)
router.delete('/:id', auth, authorize('admin'), catchAsync(customersController.deleteCustomer));

module.exports = router;
