const express = require('express');
const router = express.Router();
const { 
  getAllCoupons,
  getCouponById,
  createCoupon,
  updateCoupon,
  deleteCoupon,
  toggleCouponStatus,
  getCouponStatistics,
  searchCoupons,
  getActiveCoupons
} = require('../controllers/couponsController');
const { auth, authorize } = require('../middleware/auth');

// Public routes (no authentication required)
router.get('/active', getActiveCoupons);

// Protected routes (require authentication)
router.get('/', auth, getAllCoupons);
router.post('/', auth, authorize('admin'), createCoupon);
router.get('/search', auth, searchCoupons);
router.get('/analytics/statistics', auth, getCouponStatistics);
router.get('/:id', auth, getCouponById);
router.put('/:id', auth, authorize('admin'), updateCoupon);
router.delete('/:id', auth, authorize('admin'), deleteCoupon);
router.patch('/:id/toggle-status', auth, authorize('admin'), toggleCouponStatus);

module.exports = router;