const { connectDB, mongoose } = require('../config/db');

// Import all models - importing them will register them with Mongoose
const BaseModel = require('./BaseModel');

// Import all models
const models = {
  Address: require('./Address'),
  Bonus: require('./Bonus'),
  Brand: require('./Brand'),
  Category: require('./Category'),
  CategoryOrder: require('./CategoryOrder'),
  DeliveryBoy: require('./DeliveryBoy'),
  DeliveryBoyCash: require('./DeliveryBoyCash'),
  Discount: require('./Discount'),
  Item: require('./Item'),
  Migration: require('./Migration'),
  Order: require('./Order'),
  OrderItem: require('./OrderItem'),
  OrderStatusHistory: require('./OrderStatusHistory'),
  PasswordReset: require('./PasswordReset'),
  Store: require('./Store'),
  Tax: require('./Tax'),
  Unit: require('./Unit'),
  User: require('./User'),
  UserAddress: require('./UserAddress')
};

// Initialize all models to ensure they're registered with Mongoose
Object.values(models).forEach(Model => {
  if (typeof Model.init === 'function') {
    Model.init();
  }
});

// Helper function to get a model by name
function getModel(name) {
  return mongoose.models[name] || models[name];
}

// Export everything
module.exports = {
  // Core
  connectDB,
  mongoose,
  BaseModel,
  getModel,
  
  // Models
  ...models
};
